/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef SPICE3_SPI_API_
#define SPICE3_SPI_API_

#include "rlTypes.h"

RL_C_API rlResult rlSfioRead(rlHandle handle, rlSfRegister reg, uint32_t* value);

RL_C_API rlResult rlSfioSpiInitConfig(rlSpiConfig* config);
RL_C_API rlResult rlSfioSpiToStringConfig(const rlSpiConfig* config, char* buffer, uint32_t bufferSize, uint32_t* stringLength);
RL_C_API rlResult rlSfioSpiLoadConfig(rlHandle handle);
RL_C_API rlResult rlSfioSpiStoreConfig(rlHandle handle);
RL_C_API rlResult rlSfioSpiGetConfig(rlHandle handle, rlSpiConfig* config);
RL_C_API rlResult rlSfioSpiSetConfig(rlHandle handle, const rlSpiConfig* config);

RL_C_API rlResult rlSfioSpiTransmit(rlHandle handle, int32_t module, const uint32_t* transmitMessage, uint32_t transmitMessageLength, bool async);
RL_C_API rlResult rlSfioSpiTransceive(rlHandle handle, int32_t module, const uint32_t* transmitMessage, uint32_t transmitMessageLength, int32_t timeoutMs,
    uint32_t* buffer, uint32_t bufferSize, uint32_t* receiveCount);
RL_C_API rlResult rlSfioSpiReceive(
    rlHandle handle, int32_t module, uint32_t readCount, int32_t timeoutMs, uint32_t* buffer, uint32_t bufferSize, uint32_t* receiveCount);

RL_C_API rlResult rlSfioSpiWaitForActiveTransfersDone(rlHandle handle, int32_t module);

#endif // SPICE3_SPI_API_
